function fdr_threshold(fdr,hits)

% The number of neurons and genes selected under indicated FDR threshold

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Neurons and Genes selected vs. FDR
results=zeros(20,3);
for i=1:20
    if i<=10
        %cutoff=i*0.01; % for 0:0.01:0.1
        cutoff=i*0.001; % for 0:0.001:0.01
    else
        %cutoff=(i-10)*0.1; % for 0.1:0.1:1.0
        cutoff=(i-10)*0.01; % for 0.01:0.01:0.10
    end
    tmp_neurons=sum(fdr<cutoff);
    tmp_genes=sum(hits(fdr<cutoff));
    results(i,1)=cutoff;
    results(i,2)=tmp_neurons;
    results(i,3)=tmp_genes;
end

scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
[Yaxes,h1,h2]=plotyy(results(:,1),results(:,2),results(:,1),results(:,3),'plot')
grid on
%set(gca,'xlim',[0 1],'xtick',[0:0.05:0.1 0.2:0.1:1])
set(gca,'xlim',[0 0.10],'xtick',[0:0.005:0.01 0.02:0.01:0.1])
set(get(gca,'Xlabel'),'String','FDR threshold')
set(Yaxes(1),'ylim',[0 1000*ceil(size(fdr,1)/1000)],'ytick',...
    0:1000*ceil(size(fdr,1)/1000)/10:1000*ceil(size(fdr,1)/1000))
set(Yaxes(2),'ylim',[0 10000*ceil(sum(hits)/10000)],'ytick',...
    0:10000*ceil(sum(hits)/10000)/10:10000*ceil(sum(hits)/10000))
set(get(Yaxes(1),'Ylabel'),'String','Nodes selected ')
set(get(Yaxes(2),'Ylabel'),'String','Genes selected ')
set(h1,'marker','*')
set(h2,'marker','o')

return
